const express = require("express");
const router = express.Router();
const courseController = require("../controllers/courseController");
const {
  uploadCourseMedia,
} = require("../storage/middlewareStorage/uploadCourseMedia");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// --- Public Routes (Protected by API Key) ---
router.route("/").get(checkApiKey, courseController.getAllCourses);

router.route("/:id").get(checkApiKey, courseController.getCourse);

// --- Protected Routes (Logged-in Admins/Super-Admins Only) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(uploadCourseMedia, courseController.createCourse);

router
  .route("/:id")
  .patch(uploadCourseMedia, courseController.updateCourse)
  .delete(courseController.deleteCourse);

module.exports = router;
